// Input handling
getControls();

// X Movement while on ground and not charging
if (onGround && !isChargingJump) {
    moveDir = rightkey - leftkey;
    if (moveDir != 0) {
        face = moveDir; // Set facing direction
    }
    xspd = moveDir * moveSpd;
} else if (isChargingJump) {
    jumpDirection = rightkey - leftkey;
    xspd = 0;

    // Update facing direction during charging
    if (jumpDirection != 0) {
        face = jumpDirection; // Set facing direction during charge
    }
}

// Apply X speed if on ground (with collision check)
if (onGround) {
    if (!place_meeting(x + xspd, y, oWall)) {
        x += xspd;
    } else {
        xspd = 0;
    }
}

// Y Movement (Jumping and Gravity)
if (onGround) {
    if (jumpKey) {
        isChargingJump = true;
        jumpCharge += 1;
        if (jumpCharge > maxJumpCharge) jumpCharge = maxJumpCharge;
        show_debug_message("Charging jump: " + string(jumpCharge));
    }

    if ((!jumpKey && isChargingJump) || jumpCharge == maxJumpCharge) {
        if (jumpCharge >= minJumpCharge) {
            yspd = lerp(jspd[1], jspd[0], (jumpCharge - minJumpCharge) / (maxJumpCharge - minJumpCharge));
            jumpSpeed = jumpDirection * (moveSpd + 2);
            xspd = jumpSpeed;
            onGround = false;
        }
        isChargingJump = false;
        jumpCharge = 0;
    }
} else {
    yspd += grav;
}

// Wall bounce logic (air collision with walls)
if (!onGround && place_meeting(x + xspd, y, oWall)) {
    xspd = -xspd * 0.4; // Reverse and damp horizontal speed
    yspd = yspd * 1;  // Slightly reduce vertical speed
    show_debug_message("Wall bounce! xspd: " + string(xspd) + ", yspd: " + string(yspd));

    var _pixelCheck = sign(xspd) * -1;
    while (place_meeting(x + _pixelCheck, y, oWall)) {
        x -= _pixelCheck;
    }
}

// Limit falling speed (Terminal velocity)
if (yspd > termVel) {
    yspd = termVel;
}

// Y Collision (Check for collisions while moving vertically)
if (place_meeting(x, y + yspd, oWall)) {
    var _pixelCheck = sign(yspd) * 0.5;
    while (!place_meeting(x, y + _pixelCheck, oWall)) {
        y += _pixelCheck;
    }

    if (yspd < 0) {
        jumpHoldTimer = 0;
    }
    yspd = 0;
}

// Apply X and Y speeds
x += xspd;
y += yspd;

// Ground detection
if (place_meeting(x, y + 1, oWall) && !place_meeting(x, y, oWall)) {
    onGround = true;
} else {
    onGround = false;
}

// Character sprite control
if (isChargingJump) {
    sprite_index = chargeSpr;
} else if (abs(xspd) > 0 && !isChargingJump) {
    sprite_index = walkSpr;
} else if (xspd == 0 && !isChargingJump) {
    sprite_index = idleSpr;
} else if (!onGround) {
    sprite_index = jumpSpr;
}

// Set collision mask
mask_index = maskSpr;

